<?php

namespace \App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Advertiser extends Model 
{

    protected $table = 'advertisers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function postCategories()
    {
        return $this->hasMany('\App\Model\Category');
    }

    public function campaigns()
    {
        return $this->hasMany('\App\Model\Campaign');
    }

}